namespace win
	#include "windows.bi"
end namespace
using win
#include "resource.bi"

declare function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"

dim shared as win.HWND g_hToolbar = NULL

function ToolDlgProc( _
	byval hwnd as win.HWND, _
	byval msg as win.UINT, _
	byval wParam as win.WPARAM, _
	byval lParam as win.LPARAM) as win.BOOL
	
	select case msg
	
		case WM_COMMAND
		
			select case LOWORD(wParam)
				case IDC_PRESS
					win.MessageBox(hwnd, "Hi!", "This is a message", _
						MB_OK or MB_ICONEXCLAMATION)
				case IDC_OTHER
					win.MessageBox(hwnd, "Bye!", "This is also a message", _
						MB_OK or MB_ICONEXCLAMATION)
			end select
			
		case else
			return FALSE
	end select
	return TRUE	
end function


function WndProc( _
	byval hwnd as win.HWND, _
	byval msg as win.UINT, _
	byval wParam as win.WPARAM, _
	byval lParam as win.LPARAM) as win.LRESULT
	
	select case msg
	
		case WM_CREATE
			g_hToolbar = win.CreateDialog(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_TOOLBAR), hwnd, @ToolDlgProc() )
			if(g_hToolbar <> NULL) then
				win.ShowWindow(g_hToolbar, SW_SHOW)
			else
				win.MessageBox(hwnd, "CreateDialog returned NULL", "Warning!", _	
					MB_OK or MB_ICONINFORMATION)
			end if
			
		case WM_COMMAND
			select case LOWORD(wParam)
				case ID_FILE_EXIT
					win.PostMessage(hwnd, WM_CLOSE, 0, 0)
					
				case ID_DIALOG_SHOW
					win.ShowWindow(g_hToolbar, SW_SHOW)
					
				case ID_DIALOG_HIDE
					win.ShowWindow(g_hToolbar, SW_HIDE)
			end select
			
		case WM_CLOSE
			win.DestroyWindow(hwnd)
			
		case WM_DESTROY
			win.DestroyWindow(g_hToolbar)
			win.PostQuitMessage(0)
			
		case else
			return win.DefWindowProc(hwnd, msg, wParam, lParam)
	end select
	return 0
end function


function WinMain ( _
	byval hInstance as win.hInstance, _
	byval hPrevInstance as win.hInstance, _
	byval lpCmdLine as win.LPSTR, _
	byval nCmdShow as integer ) as integer
	
	dim as win.WNDCLASSEX wc
	dim as win.HWND hwnd
	dim as win.MSG msg
  
  	with wc
	.cbSize        = sizeof(win.WNDCLASSEX)
	.style         = 0
	.lpfnWndProc   = @WndProc()
	.cbClsExtra    = 0
	.cbWndExtra    = 0
	.hInstance     = hInstance
	.hIcon         = LoadIcon(NULL, IDI_APPLICATION)
	.hCursor       = LoadCursor(NULL, IDC_ARROW)
	.hbrBackground = cast(HBRUSH, (COLOR_WINDOW+1))
	.lpszMenuName  = MAKEINTRESOURCE(IDR_MYMENU)
	.lpszClassName = strptr(g_szClassName)
	.hIconSm       = LoadIcon(NULL, IDI_APPLICATION)
	end with

	if( win.RegisterClassEx( @wc ) = 0 ) then
		win.MessageBox( NULL, "Window Registration Failed!", "Error!", _
			MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if

	hwnd = win.CreateWindowEx( _
		WS_EX_CLIENTEDGE, _
		g_szClassName, _
		"The title of my window", _
		WS_OVERLAPPEDWINDOW, _
		CW_USEDEFAULT, CW_USEDEFAULT, 240, 120, _
		NULL, NULL, hInstance, NULL ) 

	if ( hwnd = NULL ) then
		win.MessageBox(NULL, "Window Creation Failed!", "Error!", MB_ICONEXCLAMATION or MB_OK )
		return 0
	end if

	win.ShowWindow( hwnd, nCmdShow )
	win.UpdateWindow( hwnd )

	while ( win.GetMessage( @Msg, NULL, 0, 0) > 0 )
		if( win.IsDialogMessage(g_hToolbar, @msg) = 0 ) then
			win.TranslateMessage(@Msg)
			win.DispatchMessage(@Msg)
		end if
	wend
	return Msg.wParam
	
end function